#for printing logl results into tables used in MS

library(ggplot2)
library(reshape)
library(ggthemes)
library(scales)
library(dplyr)
library(Hmisc)
library(xtable)

load("Output/loglresult - checkerboard.RData")
load("Output/loglresult - lat.RData")
load("Output/loglresult - checkerboard - thinned.RData")
load("Output/loglresult - lat - thinned.RData")

################################################################################################
logl.checkerboard.ex.mean <- aggregate(logl ~ Model + speciesName, data = logl.checkerboard, FUN= "mean" )


#do some wilcox and mean diff
table2 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table2[i,j] <- wilcox.test(logl.checkerboard.ex.mean[which(logl.checkerboard.ex.mean$Model == levels(logl.checkerboard.ex.mean$Model)[i]),3],
                                       logl.checkerboard.ex.mean[which(logl.checkerboard.ex.mean$Model == levels(logl.checkerboard.ex.mean$Model)[j]),3],
                                       paired = T)$p.value            
        }else{
            table2[i,j] <- mean(logl.checkerboard.ex.mean[which(logl.checkerboard.ex.mean$Model == levels(logl.checkerboard.ex.mean$Model)[i]),3] - 
                                    logl.checkerboard.ex.mean[which(logl.checkerboard.ex.mean$Model == levels(logl.checkerboard.ex.mean$Model)[j]),3])   
        }
        table2[i,i] <- NA
        
    }
}

colnames(table2) <- as.character(levels(logl.checkerboard$Model))
rownames(table2) <- as.character(levels(logl.checkerboard$Model))


#print it
xtable(table2, digits = 2)


logl.lat.ex.mean <- aggregate(logl ~ Model + speciesName, data = logl.lat, FUN= "mean" )


#do mean diff and 
table4 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table4[i,j] <- as.character(sum(logl.lat.ex.mean[which(logl.lat.ex.mean$Model == levels(logl.lat.ex.mean$Model)[i]),3] >= 
                                                logl.lat.ex.mean[which(logl.lat.ex.mean$Model == levels(logl.lat.ex.mean$Model)[j]),3]))           
        }else{
            table4[i,j] <- sprintf("%.2f", round(round(mean(logl.lat.ex.mean[which(logl.lat.ex.mean$Model == levels(logl.lat.ex.mean$Model)[i]),3] - 
                                                                logl.lat.ex.mean[which(logl.lat.ex.mean$Model == levels(logl.lat.ex.mean$Model)[j]),3]),2),2))
        }
        table4[i,i] <- NA
        
    }
}

colnames(table4) <- as.character(levels(logl.lat$Model))
rownames(table4) <- as.character(levels(logl.lat$Model))


#print it
xtable(table4, digits = 2)
################################################################################################
#thinned

logl.checkerboard.thinned.ex.mean <- aggregate(logl ~ Model + speciesName, data = logl.checkerboard.thinned, FUN= "mean" )


#do wilcox and mean diff
table2 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table2[i,j] <- wilcox.test(logl.checkerboard.thinned.ex.mean[which(logl.checkerboard.thinned.ex.mean$Model == levels(logl.checkerboard.thinned.ex.mean$Model)[i]),3],
                                       logl.checkerboard.thinned.ex.mean[which(logl.checkerboard.thinned.ex.mean$Model == levels(logl.checkerboard.thinned.ex.mean$Model)[j]),3],
                                       paired = T)$p.value            
        }else{
            table2[i,j] <- mean(logl.checkerboard.thinned.ex.mean[which(logl.checkerboard.thinned.ex.mean$Model == levels(logl.checkerboard.thinned.ex.mean$Model)[i]),3] - 
                                    logl.checkerboard.thinned.ex.mean[which(logl.checkerboard.thinned.ex.mean$Model == levels(logl.checkerboard.thinned.ex.mean$Model)[j]),3])   
        }
        table2[i,i] <- NA
        
    }
}

colnames(table2) <- as.character(levels(logl.checkerboard.thinned$Model))
rownames(table2) <- as.character(levels(logl.checkerboard.thinned$Model))


#print it
xtable(table2, digits = 2)

#same for lat
logl.lat.thinned.ex.mean <- aggregate(logl ~ Model + speciesName, data = logl.lat.thinned, FUN= "mean" )


table4 <- matrix(nrow = 14, ncol = 14)


for (i in 1:14){
    for (j in 1:14){
        if (j < i){
            table4[i,j] <- as.character(sum(logl.lat.thinned.ex.mean[which(logl.lat.thinned.ex.mean$Model == levels(logl.lat.thinned.ex.mean$Model)[i]),3] >= 
                                                logl.lat.thinned.ex.mean[which(logl.lat.thinned.ex.mean$Model == levels(logl.lat.thinned.ex.mean$Model)[j]),3]))           
        }else{
            table4[i,j] <- sprintf("%.2f", round(round(mean(logl.lat.thinned.ex.mean[which(logl.lat.thinned.ex.mean$Model == levels(logl.lat.thinned.ex.mean$Model)[i]),3] - 
                                                                logl.lat.thinned.ex.mean[which(logl.lat.thinned.ex.mean$Model == levels(logl.lat.thinned.ex.mean$Model)[j]),3]),2),2))
        }
        table4[i,i] <- NA
        
    }
}

colnames(table4) <- as.character(levels(logl.lat.thinned$Model))
rownames(table4) <- as.character(levels(logl.lat.thinned$Model))


#print it
xtable(table4, digits = 2)

